<?php 
class ControllerProductAll extends Controller { 	
	public function index() { 
    	$this->language->load('product/all');
	  	  
    	$this->document->title = $this->language->get('heading_title');

		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => (HTTP_SERVER . 'index.php?route=common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

		$url = '';
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}	

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
				
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}	
			
   		$this->document->breadcrumbs[] = array(
       		'href'      => (HTTP_SERVER . 'index.php?route=product/all' . $url),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => $this->language->get('text_separator')
   		);
		
    	$this->data['heading_title'] = $this->language->get('heading_title');
   
		$this->data['text_sort'] = $this->language->get('text_sort');
		$this->data['text_limit'] = $this->language->get('text_limit');
			 
  		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pd.name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		if (isset($this->request->get['limit'])) {
			$limit = $this->request->get['limit'];
		} else {
			$limit = '100';
		}
	
		$this->load->model('catalog/product');
			
		$product_total = $this->getTotalProducts();
						
		if ($product_total) {
			$url = '';
				
			$this->load->model('catalog/review');
			$this->load->model('tool/seo_url');
			
			if (file_exists(DIR_APPLICATION . 'model/tool/image.php')) {
				$this->load->model('tool/image'); // v1.4.4
			} else {
				$this->load->helper('image'); // pre-v1.4.4
			}
				
       		$this->data['products'] = array();
				
			$results = $this->getAllProducts($sort, $order, ($page - 1) * $limit, $limit);
        		
			foreach ($results as $result) {
				if ($result['image']) {
					$image = $result['image'];
				} else {
					$image = 'no_image.jpg';
				}						
					
				$rating = $this->model_catalog_review->getAverageRating($result['product_id']);	
				
				$special = $this->model_catalog_product->getProductSpecial($result['product_id']);
			
				if ($special) {
					$special = $this->currency->format($this->tax->calculate($special, $result['tax_class_id'], $this->config->get('config_tax')));
				} else {
					$special = FALSE;
				}
						
				$this->data['products'][] = array(
           			'name'    => $result['name'],
					'model'   => $result['model'],
					'rating'  => $rating,
					'stars'   => sprintf($this->language->get('text_stars'), $rating),
           			//'thumb'   => (class_exists('HelperImage')) ? HelperImage::resize($image, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')) : image_resize($image, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')),
					'thumb'   => (class_exists('HelperImage')) ? HelperImage::resize($image, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')) : (class_exists('ModelToolImage')) ? $this->model_tool_image->resize($image, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')) : image_resize($image, $this->config->get('config_image_product_width'), $this->config->get('config_image_product_height')),
           			'price'   => $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax'))),
					'special' => $special,
					'href'    => $this->model_tool_seo_url->rewrite((HTTP_SERVER . 'index.php?route=product/product' . $url . '&product_id=' . $result['product_id']))
       			);
        	}
				
			$url = '';
				
			$this->data['sorts'] = array();
				
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_name_asc'),
				'value' => 'pd.name',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=pd.name')
			); 

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_name_desc'),
				'value' => 'pd.name-DESC',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=pd.name&order=DESC')
			);  

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_price_asc'),
				'value' => 'p.price-ASC',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=p.price&order=ASC')
			); 

			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_price_desc'),
				'value' => 'p.price-DESC',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=p.price&order=DESC')
			); 
				
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_rating_desc'),
				'value' => 'rating-DESC',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=rating&order=DESC')
			); 
				
			$this->data['sorts'][] = array(
				'text'  => $this->language->get('text_rating_asc'),
				'value' => 'rating-ASC',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&sort=rating&order=ASC')
			);
			
			$this->data['limits'] = array();
				
			$this->data['limits'][] = array(
				'text'  => '10',
				'value' => '10',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&limit=10')
			);
			
			$this->data['limits'][] = array(
				'text'  => '25',
				'value' => '25',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&limit=25')
			);
			
			$this->data['limits'][] = array(
				'text'  => '50',
				'value' => '50',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&limit=50')
			);
			
			$this->data['limits'][] = array(
				'text'  => '100',
				'value' => '100',
				'href'  => (HTTP_SERVER . 'index.php?route=product/all' . $url . '&limit=100')
			);
				
			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}
			
			if (isset($this->request->get['limit'])) {
				$url .= '&limit=' . $this->request->get['limit'];
			}
			
			if (isset($this->request->get['page']) && $product_total < $limit) {
				$url .= '&page=' . $this->request->get['page'];
			}
			
			$pagination = new Pagination();
			$pagination->total = $product_total;
			$pagination->page = ($product_total < (isset($this->request->get['limit'])) ? '1' : $page);
			$pagination->limit = (isset($this->request->get['limit'])) ? $this->request->get['limit'] : 100; 
			$pagination->text = $this->language->get('text_pagination');
			if (class_exists('ModelToolImage')) {
				$pagination->url = (HTTP_SERVER . 'index.php?route=product/all' . $url . '&page={page}');
			} else {
				$pagination->url = (HTTP_SERVER . 'index.php?route=product/all' . $url . '&page=%s');
			}
				
			$this->data['pagination'] = $pagination->render();
				
			$this->data['sort'] = $sort;
			$this->data['order'] = $order;
			$this->data['limit'] = $limit;
			
			$this->id       = 'content';

			//Q: pre-1.3.3 Backwards compatibility check
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/product/all.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/product/all.tpl';
			} elseif (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'product/all.tpl')) { //v1.3.2
				$this->template = $this->config->get('config_template') . 'product/all.tpl';
			} else {
				$this->template = 'default/template/product/all.tpl';
			}

			if ($this->config->get('config_guest_checkout') != null) {
				$this->children = array(
					'common/header',
					'common/column_left',
					'common/column_right',
					'common/footer'
				);
				$this->response->setOutput($this->render(TRUE));
			} else {
				$this->layout   = 'common/layout';
				$this->render();
			}
		} else {
      		$this->data['text_error'] = $this->language->get('text_empty');

      		$this->data['button_continue'] = $this->language->get('button_continue');

      		$this->data['continue'] = (HTTP_SERVER . 'index.php?route=common/home');
	  			
			$this->id       = 'content';
			//$this->template = $this->config->get('config_template') . 'error/not_found.tpl';
			if (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . '/template/error/not_found.tpl')) {
				$this->template = $this->config->get('config_template') . '/template/error/not_found.tpl';
			} elseif (file_exists(DIR_TEMPLATE . $this->config->get('config_template') . 'error/not_found.tpl')) { //v1.3.2
				$this->template = $this->config->get('config_template') . 'error/not_found.tpl';
			} else {
				$this->template = 'default/template/error/not_found.tpl';
			}
			if ($this->config->get('config_guest_checkout') != null) {
				$this->children = array(
					'common/header',
					'common/column_left',
					'common/column_right',
					'common/footer'
				);
				$this->response->setOutput($this->render(TRUE));
			} else {
				$this->layout   = 'common/layout';
				$this->render();
			}
		}
  	}
  	
  	public function getTotalProducts() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product WHERE status = '1' AND date_available <= NOW()");
		
		return $query->row['total'];
	}
  	
  	private function getAllProducts($sort = 'pd.name', $order = 'ASC', $start = 0, $limit = 20) {
		$sql = "SELECT *, pd.name AS name, p.image, m.name AS manufacturer, ss.name AS stock, (SELECT AVG(r.rating) FROM " . DB_PREFIX . "review r WHERE p.product_id = r.product_id GROUP BY r.product_id) AS rating FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "manufacturer m ON (p.manufacturer_id = m.manufacturer_id) LEFT JOIN " . DB_PREFIX . "stock_status ss ON (p.stock_status_id = ss.stock_status_id) WHERE p.status = '1' AND p.date_available <= NOW() AND pd.language_id = '" . (int)((method_exists($this->language, 'getId')) ? (int)$this->language->getId() : (int)$this->config->get('config_language_id')) . "' AND ss.language_id = '" . (int)((method_exists($this->language, 'getId')) ? (int)$this->language->getId() : (int)$this->config->get('config_language_id')) . "'";

		$sort_data = array(
			'pd.name',
			'p.price',
			'rating'
		);	
			
		if (in_array($sort, $sort_data)) {
			$sql .= " ORDER BY " . $sort;
		} else {
			$sql .= " ORDER BY pd.name";	
		}
			
		if ($order == 'DESC') {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}
			
		$sql .= " LIMIT " . (int)$start . "," . (int)$limit;
		
		$query = $this->db->query($sql);
		
		//Q: Restricted Categories support
		if (method_exists($this->model_catalog_product, 'removeRestricted')) {
			$query = $this->model_catalog_product->removeRestricted($query);
			if (empty($query->rows)) { $query->row = array(); }
		}
		//
		
		return $query->rows;
	} 
}
?>